/*  Erstellt "INSERT INTO"-Statemane mit SELECT (als Datenquelle ). */
SELECT tsystem.function__drop_by_regex( 'scheduling_log__version__restore_from', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.scheduling_log__version__restore_from(
        IN _TableName           varchar,
        IN _version             timestamp,
        IN _fieldlist_no_recriate_array    varchar[] default null        --- Feldliste, nicht übernehmen
    ) RETURNS VOID AS $$
  DECLARE  _script              text;
           _into_script         text;
           _select_script       text;
           _on_conflict_script  text;
           _rec                 record;
           _sl_json             jsonb;
           _max_length          integer;
           _fn_primary_key      varchar;     --- on conflict -Script: primary key
           _column_name         varchar[];   --- Spaltenname foreign Tabelle
           _rev_table           varchar[];   --- primary Tabellename
           _rev_column_name     varchar[];   --- Spaltenname primary Tabelle
  BEGIN

      --- Feldliste - nicht wiederherstellen
      _fieldlist_no_recriate_array := array_cat (_fieldlist_no_recriate_array, array['dbrid', 'insert_date', 'insert_by', 'modified_date', 'modified_by']::varchar[] );

    SELECT
        kcu.column_name
      FROM information_schema.table_constraints         AS tc
        JOIN information_schema.key_column_usage        AS kcu ON tc.constraint_name  = kcu.constraint_name AND tc.table_schema = kcu.table_schema
        JOIN information_schema.constraint_column_usage AS ccu ON ccu.constraint_name = tc.constraint_name
      WHERE tc.constraint_type = 'PRIMARY KEY'
        AND tc.table_schema || '.' || tc.table_name = ( SELECT sl_tablename FROM scheduling.scheduling_log WHERE sl_tablename = _TableName AND sl_time = _version LIMIT 1 )
      INTO _fn_primary_key;

      --- Information von Referez Tabellen in drei Array übernehmen
      SELECT
      array_agg( kcu_column_name ),
        array_agg( rev_table ),
        array_agg( rev_column_name )
    FROM (
           SELECT
             kcu.column_name AS kcu_column_name,
             ccu.table_schema  || '.' || ccu.table_name AS rev_table,
             ccu.column_name AS rev_column_name
           FROM information_schema.table_constraints         AS tc
             JOIN information_schema.key_column_usage        AS kcu ON tc.constraint_name  = kcu.constraint_name AND tc.table_schema = kcu.table_schema
             JOIN information_schema.constraint_column_usage AS ccu ON ccu.constraint_name = tc.constraint_name
           WHERE tc.constraint_type = 'FOREIGN KEY'
             AND tc.table_schema || '.' || tc.table_name = ( SELECT sl_tablename FROM scheduling.scheduling_log WHERE sl_tablename = _TableName AND sl_time = _version LIMIT 1 )
       ORDER BY kcu.column_name
         ) AS sub
      INTO _column_name, _rev_table, _rev_column_name;
    ---

      SELECT sl_json
      FROM scheduling.scheduling_log
      WHERE sl_tablename = _TableName
      AND sl_time  = _version
      LIMIT 1
      INTO _sl_json;

      SELECT *
      FROM tlog.auditlog__json__into_sql__replicate( _TableName, _sl_json::json, 1, _fieldlist_no_recriate_array )
      INTO _into_script;
    _into_script := trim( _into_script );

    _select_script := 'SELECT ' || tlog.auditlog__json__fieldlist( _TableName, _sl_json::json, _fieldlist_no_recriate_array, 'sub' ) || chr(10);
      _select_script := _select_script || 'FROM (' || chr(10);
      _select_script := _select_script || '       SELECT myrecord.*' || chr(10);
      _select_script := _select_script || '       FROM scheduling.scheduling_log AS s' || chr(10);
      _select_script := _select_script || '        JOIN LATERAL jsonb_populate_record( null::'|| _TableName || ' , sl_json ) AS myrecord ON true' || chr(10);
      _select_script := _select_script || '       WHERE    sl_tablename = ' || quote_literal( _TableName ) || chr(10);
      _select_script := _select_script || '         AND sl_time = ' || quote_literal( _version ) || chr(10);
      _select_script := _select_script || ' ) AS sub' || chr(10);
    _select_script := _select_script || 'WHERE true ' || chr(10);

      FOR i IN 1..array_length(_column_name, 1) LOOP
        IF NOT TSystem.Equals( _rev_table[i] , _TableName ) THEN   --- Referenz in gleiche Tabelle nicht prüfen
              _select_script := _select_script || ' AND CASE WHEN sub.' || _column_name[i] || ' IS NOT null THEN exists( SELECT true FROM '
                             || replace( _rev_table[i], 'public.', '' ) || ' WHERE ' || _rev_column_name[i] || ' = sub.' || _column_name[i]
                             || ' ) ELSE true END' || chr(10);
      END IF;
      END LOOP;

      --- on conflict
    _on_conflict_script := 'ON CONFLICT ( ' || _fn_primary_key || ' )' || chr(10) || '  DO UPDATE SET ' || chr(10);

      SELECT max( char_length( key ) )
      FROM json_each_text( _sl_json::json )
      WHERE coalesce( array_position( _fieldlist_no_recriate_array, key::varchar ), 0 ) = 0 LIMIT 1
      INTO _max_length;

      FOR _rec IN
          SELECT key, replace( value, chr(10), ' ' ) AS value
          FROM (
                SELECT *
                FROM json_each_text( _sl_json::json )
               ) AS sub
          WHERE coalesce( array_position( _fieldlist_no_recriate_array, key::varchar ), 0 ) = 0
      LOOP
          _on_conflict_script := _on_conflict_script || '      ' || _rec.key || repeat(' ', _max_length + 1 - char_length( _rec.key ) ) || ' = excluded.' || _rec.key || ',' || chr(10);
      END LOOP;

      _on_conflict_script := substring( _on_conflict_script FROM 1 FOR char_length( _on_conflict_script ) - 2 );
      _on_conflict_script := _on_conflict_script || ';';


      --- Scripe zusammenführen
      _script := 'SELECT execution_flag__aquire( _flagname => ''inTerminierung'' );' || chr(10) || chr(10);

      _script := _script || concat_ws( chr(10), _into_script, _select_script, _on_conflict_script ) || chr(10) || chr(10);

      _script := _script || 'SELECT execution_flag__release( _flagname => ''inTerminierung'' );' || chr(10);


      PERFORM TSystem.execution_flag__aquire( _flagname => 'upsert_for_abk' );

      -- raise notice '%', _script;
      EXECUTE _script;

      PERFORM TSystem.execution_flag__release( _flagname => 'upsert_for_abk');

  END $$ LANGUAGE plpgsql;